package main

import (
	"fmt"
	"time"

	"github.com/heroku/rollrus"

	"code.justin.tv/cb/kinesis_processor/app"
	"code.justin.tv/cb/kinesis_processor/clients"
	"code.justin.tv/cb/kinesis_processor/config"
)

func main() {
	// Load config
	conf := config.LoadConfig()

	// Set up Rollbar
	rollrus.SetupLogging(conf.RollbarToken, conf.Environment)

	// Init clients
	appClients := clients.NewAppClients(conf)
	// KinesisProcessor.process
	mainApp := app.NewKinesisProcessor(appClients)
	go mainApp.Process()

	for {
		time.Sleep(1 * time.Minute)
		fmt.Println(time.Now())
	}
}
