package models

import "time"

// ChatEvent struct that gets saved into dynamodb
type ChatEvent struct {
	Time      time.Time
	ChannelID int64
	UserID    int64
}

// ChatActivity struct retrieved from dynamodb
type ChatActivity struct {
	Time      DynamoDBTimestamp
	ChannelID int64
	Chat      map[string]int64
}

// Represents a session level overview of chat activity. Intended for
// longer time ranges where only high level stats are needed.
type ChatSummary struct {
	Time         DynamoDBTimestamp
	ChannelID    int64
	Participants int64
	Messages     int64
}

// We define a type for a collection of ChatActivity structs. This allows
// us to define a custom sort on an array of chat activity so that
// we can ensure it is ordered by time.
type ChatTimeSlice []ChatActivity

func (t ChatTimeSlice) Len() int {
	return len(t)
}

func (t ChatTimeSlice) Less(i int, j int) bool {
	return t[i].Time.Converted.Before(t[j].Time.Converted)
}

func (t ChatTimeSlice) Swap(i int, j int) {
	t[i], t[j] = t[j], t[i]
}
