package models

import (
	"code.justin.tv/cb/kinesis_processor/utils"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"net/url"
	"time"
)

// VideoPlay
type VideoPlay struct {
	Time          time.Time
	ChannelID     int64
	HostChannelID int64
	Referrer      *url.URL
	ReferrerHost  string
	ReferrerUrl   *url.URL
	Live          bool
	Country       string
	City          string
	Content       string
	ContentMode   string
	Player        string
	Medium        string
	Platform      string
	DeviceID      string
}

// our tables store time in "2006-01-02 15:04:05" format
// this is a custom unmarshaller that will parse the times
// appropriately
type DynamoDBTimestamp struct {
	Converted time.Time
}

func (u *DynamoDBTimestamp) UnmarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	val := av.S
	if val == nil {
		return nil
	}

	t, err := time.Parse(utils.DbTimeFormat, *val)
	if err != nil {
		return err
	}

	u.Converted = t
	return nil
}

// GeoMap
type GeoMap struct {
	Time      DynamoDBTimestamp
	ChannelID int64
	Geo       map[string]int64
}

// UniqueDevices
type UniqueDevices struct {
	Time      DynamoDBTimestamp
	ChannelID int64
	DeviceID  map[string]int64
}

// PlatformMap
type PlatformMap struct {
	Time      DynamoDBTimestamp
	ChannelID int64
	Platform  map[string]int64
}

// ReferralMap
type ReferralMap struct {
	Time      DynamoDBTimestamp
	ChannelID int64
	Internal  map[string]int64
	External  map[string]int64
}
