resource "aws_dynamodb_table" "minute-broadcasts" {
    name = "CbMinuteBroadcasts"
    read_capacity = "${var.dynamo_read_capacities["minute-broadcasts"]}"
    write_capacity = "${var.dynamo_write_capacities["minute-broadcasts"]}"
    hash_key = "ChannelID"
    range_key = "Time"
    attribute {
      name = "ChannelID"
      type = "N"
    }
    attribute {
      name = "Time"
      type = "S"
    }

  global_secondary_index {
    name               = "TimeIndex"
    hash_key           = "Time"
    range_key          = "ChannelID"
    read_capacity = "${var.dynamo_read_capacities["minute-broadcasts"]}"
    write_capacity = "${var.dynamo_write_capacities["minute-broadcasts"]}"
    projection_type    = "ALL"
  }
}

resource "aws_dynamodb_table" "channel-updates" {
  name = "CbChannelUpdates"
  read_capacity = "${var.dynamo_read_capacities["channel-updates"]}"
  write_capacity = "${var.dynamo_write_capacities["channel-updates"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "channel-concurrents" {
  name = "CbChannelConcurrents"
  read_capacity = "${var.dynamo_read_capacities["channel-concurrents"]}"
  write_capacity = "${var.dynamo_write_capacities["channel-concurrents"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "channel-sessions" {
  name = "CbChannelSessions"
  read_capacity = "${var.dynamo_read_capacities["channel-sessions"]}"
  write_capacity = "${var.dynamo_write_capacities["channel-sessions"]}"
  hash_key = "ChannelID"
  range_key = "StartTime"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "StartTime"
    type = "S"
  }
}


resource "aws_dynamodb_table" "incremental-follows" {
  name = "CbIncrementalFollows"
  read_capacity = "${var.dynamo_read_capacities["incremental-follows"]}"
  write_capacity = "${var.dynamo_write_capacities["incremental-follows"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "follows-aggregate" {
  name = "CbFollowsAggregate"
  read_capacity = "${var.dynamo_read_capacities["follows-aggregate"]}"
  write_capacity = "${var.dynamo_write_capacities["follows-aggregate"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "clips" {
  name = "CbClips"
  read_capacity = "${var.dynamo_read_capacities["clips"]}"
  write_capacity = "${var.dynamo_write_capacities["clips"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "clipid-to-channel-time" {
  name = "CbClipIDToChannelTime"
  read_capacity = "${var.dynamo_read_capacities["clipid-channeltime"]}"
  write_capacity = "${var.dynamo_write_capacities["clipid-channeltime"]}"
  hash_key = "ClipID"
  range_key = "Time"
  attribute {
    name = "ClipID"
    type = "S"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-plays-geo" {
  name = "CbChannelGeo"
  read_capacity = "${var.dynamo_read_capacities["video-plays-geo"]}"
  write_capacity = "${var.dynamo_write_capacities["video-plays-geo"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-plays-referrer" {
  name = "CbChannelReferral"
  read_capacity = "${var.dynamo_read_capacities["video-plays-referrer"]}"
  write_capacity = "${var.dynamo_write_capacities["video-plays-referrer"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-plays-platform" {
  name = "CbChannelPlatform"
  read_capacity = "${var.dynamo_read_capacities["video-plays-platform"]}"
  write_capacity = "${var.dynamo_write_capacities["video-plays-platform"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "chat-activity" {
  name = "CbChatActivity"
  read_capacity = "${var.dynamo_read_capacities["chat-activity"]}"
  write_capacity = "${var.dynamo_write_capacities["chat-activity"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "commercials" {
  name = "CbCommercials"
  read_capacity = "${var.dynamo_read_capacities["commercials"]}"
  write_capacity = "${var.dynamo_write_capacities["commercials"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "raids" {
  name = "CbRaids"
  read_capacity = "${var.dynamo_read_capacities["raids"]}"
  write_capacity = "${var.dynamo_write_capacities["raids"]}"
  hash_key = "TargetID"
  range_key = "Time"
  attribute {
    name = "TargetID"
    type = "S"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}

resource "aws_dynamodb_table" "unique-plays" {
  name = "CbChannelUniquePlays"
  read_capacity = "${var.dynamo_read_capacities["unique-plays"]}"
  write_capacity = "${var.dynamo_write_capacities["unique-plays"]}"
  hash_key = "ChannelID"
  range_key = "Time"
  attribute {
    name = "ChannelID"
    type = "N"
  }
  attribute {
    name = "Time"
    type = "S"
  }
}
