resource "aws_elasticache_cluster" "cb-chat-stats-cache" {
  cluster_id           = "${var.chat_cache_name}-${var.environment}"
  engine               = "redis"
  engine_version       = "3.2.4"
  node_type            = "${var.chat_cache_node_type}"
  port                 = 6379
  num_cache_nodes      = "1"                                                          // must be 1 for redis
  parameter_group_name = "default.redis3.2"
  security_group_ids   = ["${data.terraform_remote_state.account.twitch_subnets_sg}"]
  subnet_group_name    = "${aws_elasticache_subnet_group.cb-chat-stats-cache-subnet.name}"
}

resource "aws_elasticache_subnet_group" "cb-chat-stats-cache-subnet" {
  name       = "${var.name}-${var.chat_cache_name}-subnet-${var.environment}"
  subnet_ids = ["${split(",", "${data.terraform_remote_state.account.caching_subnets}")}"]
}
