resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Sid": ""
    },
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Principal": {
        "Service": "application-autoscaling.amazonaws.com"
      }
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "cloudwatch" {
  name = "${var.iam_role_name}-cloudwatch"
  role = "${aws_iam_role.app.id}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Action": [
          "cloudwatch:PutMetricAlarm",
          "cloudwatch:DescribeAlarms",
          "cloudwatch:DeleteAlarms"
        ],
        "Effect": "Allow",
        "Resource": "*"
      }
    ]
}
EOF
}

resource "aws_iam_role_policy" "app_s3_policy" {
  name = "${var.iam_role_name}-s3-policy"
  role = "${aws_iam_role.app.id}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Effect": "Allow",
        "Action": [
          "s3:Get*",
          "s3:Put*",
          "s3:List*",
          "s3:DeleteObject"
        ],
        "Resource": [
          "${aws_s3_bucket.sink.arn}*",
          "${aws_s3_bucket.sink.arn}/*",
          "${aws_s3_bucket.video-play.arn}*",
          "${aws_s3_bucket.video-play.arn}/*"
        ]
      }
    ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${aws_iam_role.app.name}"
  roles = [
    "${aws_iam_role.app.name}"
  ]
}

resource "aws_iam_role_policy" "dynamodb" {
  name = "${var.iam_role_name}-dynamodb-policy"
  role = "${aws_iam_role.app.id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "dynamodb:*",
      "Effect": "Allow",
      "Resource": [
        "${aws_dynamodb_table.channel-concurrents.arn}",
        "${aws_dynamodb_table.channel-updates.arn}",
        "${aws_dynamodb_table.minute-broadcasts.arn}",
        "${aws_dynamodb_table.channel-sessions.arn}",
        "${aws_dynamodb_table.incremental-follows.arn}",
        "${aws_dynamodb_table.follows-aggregate.arn}",
        "${aws_dynamodb_table.clipid-to-channel-time.arn}",
        "${aws_dynamodb_table.clips.arn}",
        "${aws_dynamodb_table.video-plays-geo.arn}",
        "${aws_dynamodb_table.video-plays-referrer.arn}",
        "${aws_dynamodb_table.video-plays-platform.arn}",
        "${aws_dynamodb_table.chat-activity.arn}",
        "${aws_dynamodb_table.commercials.arn}",
        "${aws_dynamodb_table.raids.arn}",
        "${aws_dynamodb_table.unique-plays.arn}"
      ]
    },
    {
      "Action": "dynamodb:Query",
      "Effect": "Allow",
      "Resource": [
        "${aws_dynamodb_table.channel-concurrents.arn}/index/*",
        "${aws_dynamodb_table.channel-updates.arn}/index/*",
        "${aws_dynamodb_table.minute-broadcasts.arn}/index/*",
        "${aws_dynamodb_table.channel-sessions.arn}/index/*",
        "${aws_dynamodb_table.incremental-follows.arn}/index/*",
        "${aws_dynamodb_table.follows-aggregate.arn}/index/*",
        "${aws_dynamodb_table.clipid-to-channel-time.arn}/index/*",
        "${aws_dynamodb_table.clips.arn}/index/*",
        "${aws_dynamodb_table.video-plays-geo.arn}/index/*",
        "${aws_dynamodb_table.video-plays-referrer.arn}/index/*",
        "${aws_dynamodb_table.video-plays-platform.arn}/index/*",
        "${aws_dynamodb_table.chat-activity.arn}/index/*",
        "${aws_dynamodb_table.commercials.arn}/index/*",
        "${aws_dynamodb_table.raids.arn}/index/*",
        "${aws_dynamodb_table.unique-plays.arn}/index/*"
      ]
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "app_sqs_policy" {
  name = "${var.iam_role_name}-sqs-policy"
  role = "${aws_iam_role.app.id}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "sqs:SendMessage",
                "sqs:ReceiveMessage",
                "sqs:ChangeMessageVisibility",
                "sqs:DeleteMessage",
                "sqs:GetQueueAttributes",
                "sqs:GetQueueUrl"
            ],
            "Resource": [
              "${aws_sqs_queue.session_up.arn}",
              "${aws_sqs_queue.session_down.arn}"
             ]
        }
    ]
}

EOF
}
