data "terraform_remote_state" "account" {
  backend = "s3"
  config {
    bucket = "${lookup(var.account, var.environment)}"
    key = "tfstate/web/terraform/accounts/${lookup(var.account, var.environment)}/terraform.tfstate"
    profile = "${lookup(var.account, var.environment)}"
    region = "${var.aws_region}"
  }
}

data "terraform_remote_state" "asg_lambda" {
  backend = "s3"
  config {
    bucket = "${lookup(var.account, var.environment)}"
    key = "tfstate/web/asg-r53-lambda/services/lambda/${lookup(var.account, var.environment)}/terraform.tfstate"
    profile = "${lookup(var.account, var.environment)}"
    region = "${var.aws_region}"
  }
}
