resource "aws_sqs_queue" "session_up" {
  name = "${var.name}-session-up-${var.environment}"
  delay_seconds = 90
}

resource "aws_sqs_queue" "session_down" {
  name = "${var.name}-session-down-${var.environment}"
  delay_seconds = 90
}

variable "aws_sns_session_up_arn" {
  type = "string"
  default = "arn:aws:sns:us-west-2:848744099708:TwitchStreamReadyNotifications"
  description = "SNS video arn that published to session_up events."
}

variable "aws_sns_session_down_arn" {
  type = "string"
  default = "arn:aws:sns:us-west-2:848744099708:TwitchStreamDownNotifications"
  description = "SNS video arn that published to session_down events."
}

resource "aws_sqs_queue_policy" "session_up_policy" {
  queue_url = "${aws_sqs_queue.session_up.id}"

  policy = <<POLICY
{
  "Version": "2008-10-17",
  "Id": "sqs_session_up_cross_account_policy",
  "Statement": [
    {
      "Sid": "session_up_notifications",
      "Effect": "Allow",
      "Principal": "*",
      "Resource": "${aws_sqs_queue.session_up.arn}",
      "Action": ["sqs:SendMessage"],
      "Condition": {
        "ArnEquals": {
          "aws:SourceArn": "${var.aws_sns_session_up_arn}"
        }
      }
    }
  ]
}
POLICY
}


resource "aws_sqs_queue_policy" "session_down_policy" {
  queue_url = "${aws_sqs_queue.session_down.id}"

  policy = <<POLICY
{
  "Version": "2008-10-17",
  "Id": "sqs_session_down_cross_account_policy",
  "Statement": [
    {
      "Sid": "session_down_notifications",
      "Effect": "Allow",
      "Principal": "*",
      "Resource": "${aws_sqs_queue.session_down.arn}",
      "Action": ["sqs:SendMessage"],
      "Condition": {
        "ArnEquals": {
          "aws:SourceArn": "${var.aws_sns_session_down_arn}"
        }
      }
    }
  ]
}
POLICY
}
