variable "account" {
  type = "map"

  default = {
    production = "twitch-web-aws"
    staging    = "twitch-web-dev"
  }

  description = "AWS account name"
}

variable "aws_key_name" {
  type    = "string"
  default = "cb/kinesis-processor"
}

variable "service_name" {
  type    = "string"
  default = "cb/kinesis_processor"
}

variable "aws_region" {
  type    = "string"
  default = "us-west-2"
}

variable "chat_cache_name" {
  type    = "string"
  default = "chatstats"
}

variable "chat_cache_node_type" {
  type    = "string"
  default = "cache.m4.large"
}

variable "domain" {
  type = "map"

  default = {
    production = "prod.us-west2.justin.tv"
    staging    = "dev.us-west2.justin.tv"
    staging2   = "dev2.us-west2.justin.tv"
  }
}

variable "dynamo_read_capacities" {
  type = "map"

  default = {
    "channel-concurrents"  = 1000
    "channel-sessions"     = 1000
    "channel-updates"      = 250
    "clipid-channeltime"   = 1000
    "clips"                = 1000
    "follows-aggregate"    = 1000
    "incremental-follows"  = 1000
    "minute-broadcasts"    = 1000
    "video-plays-geo"      = 500
    "video-plays-platform" = 500
    "video-plays-referrer" = 1000
    "chat-activity" = 1000
    "commercials" = 20
    "raids" = 20
    "unique-plays" = 1000
  }
}

variable "dynamo_write_capacities" {
  type = "map"

  default = {
    "channel-concurrents"  = 1000
    "channel-updates"      = 250
    "channel-sessions"     = 1000
    "clipid-channeltime"   = 500
    "clips"                = 1000
    "follows-aggregate"    = 1000
    "incremental-follows"  = 1000
    "minute-broadcasts"    = 1000
    "video-plays-geo"      = 2000
    "video-plays-platform" = 2000
    "video-plays-referrer" = 1500
    "chat-activity" = 1500
    "commercials" = 500
    "raids" = 500
    "unique-plays" = 6000
  }
}

variable "environment" {
  description = "Service environment"
}

variable "hostname" {
  type        = "string"
  default     = "cb-kinesis-processor"
  description = "DNS safe service name"
}

variable "iam_role_name" {
  type        = "string"
  default     = "cb-kinesis-processor"
  description = "Service role for controlling access to other AWS services"
}

variable "instance_type" {
  type        = "string"
  default     = "c4.xlarge"
  description = "EC2 instance type"
}

variable "max_size" {
  type = "map"

  default = {
    production = 1
    staging    = 1
    staging2   = 1
  }

  description = "Largest size a service cluster will grow to"
}

variable "min_size" {
  type = "map"

  default = {
    production = 1
    staging    = 1
    staging2   = 1
  }

  description = "Smallest size a service cluster will shrink down to"
}

variable "name" {
  type        = "string"
  default     = "cb-kinesis-processor"
  description = "Service name used for AWS tagging among other things"
}

variable "owner" {
  type        = "string"
  default     = "creatorbusiness@justin.tv"
  description = "Team email alias"
}

variable "project" {
  type        = "string"
  default     = "cb/kinesis_processor"
  description = "GitHub repository name"
}

variable "root_volume_size" {
  type        = "string"
  default     = 256
  description = "Amount of diskspace allocated to the root drive (GB)."
}

variable "stack_name" {
  type    = "string"
  default = "64bit Amazon Linux 2016.03 v2.1.0 running Docker 1.9.1"
}

variable "team" {
  type        = "string"
  default     = "Revenue"
  description = "Twitch team name"
}
