module "kinesis_processor" {
  source = "../modules/kinesis_processor"
  environment = "staging"
  instance_type = "c4.xlarge"

  #Firehouse configuration
  account-id = "465369119046"

  #Dynamo Capacities
  dynamo_read_capacities = {
    channel-concurrents = 20
    channel-sessions = 1000
    channel-updates = 20
    clipid-channeltime = 20
    clips = 20
    follows-aggregate = 20
    incremental-follows = 20
    minute-broadcasts = 50
    video-plays-geo = 20
    video-plays-platform = 20
    video-plays-referrer = 20
    chat-activity = 1000
    commercials = 20
    raids = 20
    unique-plays = 1000
  }

  dynamo_write_capacities = {
    channel-concurrents = 663
    channel-sessions = 2000
    channel-updates = 100
    clipid-channeltime = 100
    clips = 1000
    follows-aggregate = 500
    incremental-follows = 1000
    minute-broadcasts = 1000
    video-plays-geo = 3000
    video-plays-platform = 3000
    video-plays-referrer = 3000
    chat-activity = 1500
    commercials = 1000
    raids = 1000
    unique-plays = 6000
  }

  # Redis setup
  chat_cache_node_type = "cache.t2.micro"
}
