package utils

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	log "github.com/sirupsen/logrus"
	"strconv"
)

func Int64ListFromAwsArray(list []*string) []int64 {
	result := make([]int64, len(list))
	for i, value := range list {
		parsedValue, err := strconv.ParseInt(*value, 10, 64)
		result[i] = parsedValue
		if err != nil {
			log.Error(err)
		}
	}
	return result
}

func InInt64List(item int64, list []int64) bool {
	for _, value := range list {
		if value == item {
			return true
		}
	}

	return false
}

func AwsArrayFromInt64List(list []int64) []*string {
	result := make([]*string, len(list))
	for i, value := range list {
		result[i] = aws.String(strconv.FormatInt(value, 10))
	}

	return result
}

func AppendUniqueInt64(source []int64, target int64) []int64 {
	found := false
	for _, value := range source {
		if value == target {
			found = true
			break
		}
	}
	if !found {
		source = append(source, target)
	}
	return source
}

func FlattenInt64List(source [][]int64) []int64 {
	result := []int64{}

	for _, list := range source {
		for _, item := range list {
			result = AppendUniqueInt64(result, item)
		}
	}
	return result
}

// Attempts to convert a dynamoDB attribute value to an int64.  If the attribute
// value doesn't exist, 0 is returned.
func MaybeInt64(valueMap map[string]*dynamodb.AttributeValue, key string) (int64, error) {
	if _, ok := valueMap[key]; ok {
		value, err := strconv.ParseInt(*valueMap[key].N, 10, 64)
		if err != nil {
			return 0, err
		}
		return value, nil
	}
	return 0, nil
}
