package utils

import (
	"errors"
	"fmt"
	"reflect"
)

func SetField(obj interface{}, name string, value interface{}) error {
	structValue := reflect.ValueOf(obj).Elem()
	structFieldValue := structValue.FieldByName(name)

	if !structFieldValue.IsValid() {
		return fmt.Errorf("No such field: %s in obj", name)
	}

	if !structFieldValue.CanSet() {
		return fmt.Errorf("Cannot set %s field value", name)
	}

	structFieldType := structFieldValue.Type()
	val := reflect.ValueOf(value)
	if structFieldType != val.Type() {
		return errors.New("Provided value type didn't match obj field type")
	}

	structFieldValue.Set(val)
	return nil
}

func FillStruct(stringmap map[string]interface{}, obj *interface{}) error {
	for key, value := range stringmap {
		err := SetField(obj, key, value)
		if err != nil {
			return err
		}
	}
	return nil
}

func MakeMap(obj *interface{}) map[string]interface{} {
	structValue := reflect.ValueOf(obj).Elem()
	structType := reflect.TypeOf(obj)
	result := map[string]interface{}{}

	for i := 0; i < structType.NumField(); i++ {
		fieldName := structType.Field(i).Name
		fieldValue := structValue.FieldByName(fieldName)
		result[fieldName] = fieldValue.Interface()
	}

	return result
}
