package utils

import "time"

const DbTimeFormat = "2006-01-02 15:04:05"

func ConvertPSTtoUTC(input string) (*string, error) {
	loc, err := time.LoadLocation("America/Los_Angeles")
	if err != nil {
		return nil, err
	}

	result, err := time.ParseInLocation(DbTimeFormat, input, loc)
	if err != nil {
		return nil, err
	}
	resultPointer := new(string)
	*resultPointer = result.UTC().Format(DbTimeFormat)

	return resultPointer, nil
}
