﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace GlueFactory
{
    public static class Constants
    {
        private const string unloadManifestPattern = @"(?:s3:\/\/crs-data-export\/)(.*)?";
        public static Regex UnloadManifestRegex = new Regex(unloadManifestPattern, RegexOptions.Compiled | RegexOptions.Singleline | RegexOptions.IgnoreCase);

        public enum AggregationType
        {
            Lifetime = -1,
            Unknown = 0,
            Week = 7,
            ThirtyDay = 30,
            SixtyDay = 60,
            NintyDay = 90,
            BankerYear = 360,
            Year = 365
        }
    }
}
