﻿using GlueFactory.Models;
using MySql.Data.MySqlClient;
using System;
using System.Collections.Generic;
using System.Text;

namespace GlueFactory.Helpers
{
    public static class DBHelper
    {
        public static MySqlConnection GetConnection(MySqlModel data, bool open = true)
        {
            try
            {
                MySqlConnectionStringBuilder builder = GetConnectionBuilder(data);
                var conn = new MySqlConnection(builder.ConnectionString);
                if (open)
                {
                    conn.Open();
                }
                return conn;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                throw;
            }
        }

        public static MySqlCommand GetCommand(this MySqlConnection conn, string commandText = "")
        {
            try
            {
                var command = new MySqlCommand()
                {
                    Connection = conn,
                    CommandText = commandText
                };
                return command;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                throw;
            }
        }

        public static MySqlConnectionStringBuilder GetConnectionBuilder(MySqlModel data)
        {
            return new MySqlConnectionStringBuilder()
            {
                Server = data.Server,
                Port = data.Port,
                UserID = data.UserName,
                Password = data.Password,
                Database = "production",
                Pooling = data.Pooling,
                SslMode = MySqlSslMode.Required,
                SqlServerMode = true,
                UseCompression = true,
                ConvertZeroDateTime = true,
                IgnorePrepare = false
            };
        }
    }
}
