﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace GlueFactory.Models
{
    public class TableModel
    {
        [JsonProperty(PropertyName = "dpu_count")]
        public int DpuCount { get; set; } = 5;
        [JsonProperty(PropertyName = "version")]
        public int Version { get; set; } = 1;
        [JsonProperty(PropertyName = "hashfield")]
        public string Hashfield { get; set; } = "hash";
        [JsonProperty(PropertyName = "hashpartitions")]
        public int HashPartitions { get; set; } = 10;
        [JsonProperty(PropertyName = "database")]
        public string Database { get; set; } = "production";
        [JsonProperty(PropertyName = "schema")]
        public List<TableSchema> Schema { get; set; }
    }

    public class TableSchema
    {
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }
        [JsonProperty(PropertyName = "type")]
        public string Type { get; set; }
        [JsonProperty(PropertyName = "sensitivity", NullValueHandling = NullValueHandling.Ignore)]
        public string Sensitivity { get; set; }
    }
}
