provider "aws" {
  region = "us-west-2"
  version = "~> 2.44"
}

module "glue-rds" {
  source = "git::ssh://git@git.xarth.tv/dp/db-s3-glue.git?ref=e6211f16ea18a0bdd855e1147600854ae553b7dc"
  database_type = "rds"
  aurora = "True"
  skip_snapshot = "True"
  job_name = "db-s3-glue-atlas"
  cluster_name = "atlas"
  tahoe_producer_name = "atlasdbexport"
  tahoe_producer_role_arn = "arn:aws:iam::331582574546:role/producer-atlasdbexport"

table_config = {
"microservice_twitch_atlas_account_manager" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "account_manager_email",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "account_manager_first_name",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "account_manager_id",
      "type": "int"
    },
    {
      "name": "account_manager_last_name",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "account_manager_ldap_name",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "approving_manager_amazon_id",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "approving_manager_name",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "is_admin",
      "type": "boolean"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_activity_log" = <<EOF
{
  "dpu_count": 5,
  "version": 2,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "action",
      "type": "string"
    },
    {
      "name": "controller",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "id",
      "type": "int"
    },
    {
      "name": "message",
      "type": "string"
    },
    {
      "name": "message_timestamp",
      "type": "timestamp"
    },
    {
      "name": "tracking_date",
      "type": "timestamp"
    },
    {
      "name": "tracking_id",
      "type": "string"
    },
    {
      "name": "tracking_tag",
      "type": "string"
    },
    {
      "name": "user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_aggregate_pcc_stats" = <<EOF
{
  "dpu_count": 5,
  "version": 2,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "hours_broadcast",
      "type": "float"
    },
    {
      "name": "hours_watched",
      "type": "float"
    },
    {
      "name": "last_update_time",
      "type": "timestamp"
    },
    {
      "name": "measurement_date",
      "type": "timestamp"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "stat_id",
      "type": "int"
    },
    {
      "name": "total_revenue",
      "type": "float"
    }
  ]
}
EOF
"microservice_twitch_atlas_contracts" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "additional_notes",
      "type": "string"
    },
    {
      "name": "ad_density_per_hour",
      "type": "float"
    },
    {
      "name": "ad_prerolls_enabled",
      "type": "boolean"
    },
    {
      "name": "ad_revenue_contract_type",
      "type": "string"
    },
    {
      "name": "ad_revenue_share_amount_tier_1",
      "type": "float"
    },
    {
      "name": "ad_revenue_share_amount_tier_2",
      "type": "float"
    },
    {
      "name": "ad_revenue_share_amount_tier_3",
      "type": "float"
    },
    {
      "name": "ad_revenue_share_type_tier_1",
      "type": "string"
    },
    {
      "name": "ad_revenue_share_type_tier_2",
      "type": "string"
    },
    {
      "name": "ad_revenue_share_type_tier_3",
      "type": "string"
    },
    {
      "name": "auto_renew",
      "type": "boolean"
    },
    {
      "name": "bits_revenue_share_percent",
      "type": "float"
    },
    {
      "name": "contract_id",
      "type": "int"
    },
    {
      "name": "contract_name",
      "type": "string"
    },
    {
      "name": "contract_type",
      "type": "string"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "document_link",
      "type": "string"
    },
    {
      "name": "end_date",
      "type": "timestamp"
    },
    {
      "name": "exclusivity_enabled",
      "type": "boolean"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "original_end_date",
      "type": "timestamp"
    },
    {
      "name": "original_start_date",
      "type": "timestamp"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "revenue_share_enabled",
      "type": "boolean"
    },
    {
      "name": "sponsorship_enabled",
      "type": "boolean"
    },
    {
      "name": "start_date",
      "type": "timestamp"
    },
    {
      "name": "subs_revenue_share_percent",
      "type": "float"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_contract_account_manager_map" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "account_manager_id",
      "type": "int"
    },
    {
      "name": "contract_account_manager_map_id",
      "type": "int"
    },
    {
      "name": "contract_id",
      "type": "int"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_contract_channels" = <<EOF
{
  "dpu_count": 5,
  "version": 4,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "channel_id",
      "type": "bigint",
      "sensitivity": "userid"
    },
    {
      "name": "contract_channel_id",
      "type": "int"
    },
    {
      "name": "contract_id",
      "type": "int"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "custom_end_date",
      "type": "timestamp"
    },
    {
      "name": "custom_start_date",
      "type": "timestamp"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_event" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "costreaming_settings",
      "type": "string"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "distribution",
      "type": "boolean"
    },
    {
      "name": "end_time",
      "type": "timestamp"
    },
    {
      "name": "estimated_average_ccv",
      "type": "float"
    },
    {
      "name": "event_id",
      "type": "int"
    },
    {
      "name": "event_name",
      "type": "string"
    },
    {
      "name": "event_type",
      "type": "string"
    },
    {
      "name": "format",
      "type": "string"
    },
    {
      "name": "game_name",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "pledged_hours_broadcast",
      "type": "float"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "product_id",
      "type": "int"
    },
    {
      "name": "season_id",
      "type": "int"
    },
    {
      "name": "start_time",
      "type": "timestamp"
    },
    {
      "name": "sub_format",
      "type": "string"
    },
    {
      "name": "sub_topic",
      "type": "string"
    },
    {
      "name": "topic",
      "type": "string"
    },
    {
      "name": "twitch_involvement",
      "type": "string"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_formats" = <<EOF
{
  "dpu_count": 5,
  "version": 2,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "format_auto_id",
      "type": "int"
    },
    {
      "name": "format_description",
      "type": "string"
    },
    {
      "name": "format_id",
      "type": "int"
    },
    {
      "name": "format_name",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "topic_id",
      "type": "int"
    }
  ]
}
EOF
"microservice_twitch_atlas_pcc_to_am_map" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "account_manager_id",
      "type": "int"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "pcc_am_map_id",
      "type": "int"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_pcc_to_channel_map" = <<EOF
{
  "dpu_count": 5,
  "version": 4,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "channel_id",
      "type": "bigint",
      "sensitivity": "userid"
    },
    {
      "name": "channel_ownership",
      "type": "string"
    },
    {
      "name": "channel_vertical",
      "type": "string"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "pcc_channel_map_id",
      "type": "int"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_premium_content_creator" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "am_name",
      "type": "string"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "premium_content_creator_name",
      "type": "string",
      "sensitivity": "otherid"
    },
    {
      "name": "premium_content_creator_type",
      "type": "string"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_product" = <<EOF
{
  "dpu_count": 5,
  "version": 4,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "contract_id",
      "type": "int"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "format",
      "type": "string"
    },
    {
      "name": "front_page_asset",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "premium_content_creator_id",
      "type": "int"
    },
    {
      "name": "product_description",
      "type": "string"
    },
    {
      "name": "product_id",
      "type": "int"
    },
    {
      "name": "product_name",
      "type": "string"
    },
    {
      "name": "product_owner",
      "type": "string"
    },
    {
      "name": "sub_format",
      "type": "string"
    },
    {
      "name": "sub_topic",
      "type": "string"
    },
    {
      "name": "topic",
      "type": "string"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_product_assets" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "asset_file_type",
      "type": "string"
    },
    {
      "name": "asset_id",
      "type": "string"
    },
    {
      "name": "asset_location",
      "type": "string"
    },
    {
      "name": "asset_type",
      "type": "int"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "product_id",
      "type": "int"
    },
    {
      "name": "slot_data",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_season" = <<EOF
{
  "dpu_count": 5,
  "version": 3,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "end_time",
      "type": "timestamp"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "pledged_hours_broadcast",
      "type": "float"
    },
    {
      "name": "previous_season_id",
      "type": "int"
    },
    {
      "name": "previous_season_name",
      "type": "string"
    },
    {
      "name": "prize_pool",
      "type": "float"
    },
    {
      "name": "product_id",
      "type": "int"
    },
    {
      "name": "season_id",
      "type": "int"
    },
    {
      "name": "season_name",
      "type": "string"
    },
    {
      "name": "start_time",
      "type": "timestamp"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_stream" = <<EOF
{
  "dpu_count": 5,
  "version": 4,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "channel_id",
      "type": "bigint",
      "sensitivity": "userid"
    },
    {
      "name": "channel_type",
      "type": "string"
    },
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "end_time",
      "type": "timestamp"
    },
    {
      "name": "event_id",
      "type": "int"
    },
    {
      "name": "game_name",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "start_time",
      "type": "timestamp"
    },
    {
      "name": "stream_id",
      "type": "int"
    },
    {
      "name": "stream_login",
      "type": "string"
    },
    {
      "name": "updated_time",
      "type": "timestamp"
    },
    {
      "name": "updated_user",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_sub_formats" = <<EOF
{
  "dpu_count": 5,
  "version": 2,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "format_id",
      "type": "int"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "sub_format_auto_id",
      "type": "int"
    },
    {
      "name": "sub_format_description",
      "type": "string"
    },
    {
      "name": "sub_format_id",
      "type": "int"
    },
    {
      "name": "sub_format_name",
      "type": "string"
    }
  ]
}
EOF
"microservice_twitch_atlas_sub_topics" = <<EOF
{
  "dpu_count": 5,
  "version": 2,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "sub_topic_auto_id",
      "type": "int"
    },
    {
      "name": "sub_topic_description",
      "type": "string"
    },
    {
      "name": "sub_topic_id",
      "type": "int"
    },
    {
      "name": "sub_topic_name",
      "type": "string"
    },
    {
      "name": "topic_id",
      "type": "int"
    }
  ]
}
EOF
"microservice_twitch_atlas_topics" = <<EOF
{
  "dpu_count": 5,
  "version": 2,
  "hashfield": "hash",
  "hashpartitions": 1,
  "database": "production",
  "schema": [
    {
      "name": "created_time",
      "type": "timestamp"
    },
    {
      "name": "created_user",
      "type": "string"
    },
    {
      "name": "hash",
      "type": "string"
    },
    {
      "name": "is_active",
      "type": "boolean"
    },
    {
      "name": "is_gaming",
      "type": "boolean"
    },
    {
      "name": "topic_auto_id",
      "type": "int"
    },
    {
      "name": "topic_description",
      "type": "string"
    },
    {
      "name": "topic_id",
      "type": "int"
    },
    {
      "name": "topic_name",
      "type": "string"
    }
  ]
}
EOF
}

  s3_output_bucket = "db-s3-glue-atlas-db-export"
  create_s3_output_bucket = "0"
  s3_output_key = "atlas"
  s3_script_bucket = "db-s3-glue-atlas-scripts"
  error_sns_topic_name = "db-s3-glue-messages"
  account_number = "029773783190"
  vpc_id = "vpc-05915d237037a285b"
  subnet_id = "subnet-095b5489187453f4d"
  availability_zone = "us-west-2a"
  rds_subnet_group = "db-s3-glue"
  cluster_username = "atlas_dba"
  db_password_parameter_name = "rds-atlas-db-s3-glue-password"
  db_password_key_id = "32131cc3-2de6-403e-a435-c889077fa5df"
  api_key_parameter_name     = "db-s3-glue-atlas-api-key"
  api_key_kms_key_id         = "32131cc3-2de6-403e-a435-c889077fa5df"
}

output "s3_kms_key" {
  value = module.glue-rds.s3_kms_key
}

output "s3_output_bucket" {
  value = module.glue-rds.s3_output_bucket
}

output "glue_role" {
  value = module.glue-rds.glue_role
}
