package martian

import (
	"context"
	"testing"

	"code.justin.tv/cb/martian/test/twitch_client"
	"github.com/pkg/errors"
)

func TestPostApplication_ShouldFail(t *testing.T) {
	client := &twitch_client.TwitchClientMock{
		NewRequestError: errors.New("NewRequest failure"),
	}

	c := ClientImpl{Client: client}

	err := c.PostApplication(context.Background(), PostApplicationParams{}, nil)
	if err == nil {
		t.Error("Post Application should return error")
	}
}
