package api

import (
	"context"

	"code.justin.tv/cb/achievements/client/achievementsinternal"
	"code.justin.tv/cb/martian/internal/salesforce"
	"code.justin.tv/cb/martian/internal/twitter"
	"code.justin.tv/cb/martian/internal/youtube"
	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common"
	"code.justin.tv/feeds/spade"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/identity/connections/client"
	"code.justin.tv/revenue/ripley/rpc"
	"code.justin.tv/web/users-service/client/channels"
	users_models "code.justin.tv/web/users-service/models"
	"goji.io"
	"goji.io/pat"
)

type HTTPServer struct {
	service_common.BaseHTTPServer
	Config      *HTTPConfig
	Environment string

	Connections  connections.Client
	Ripley       riptwirp.Ripley
	Salesforce   SalesforceClient
	Spade        Spade
	Twitter      *twitter.Client
	Users        UsersClient
	Channels     channels.Client
	Youtube      *youtube.Client
	Achievements achievementsinternal.Client
}

type SalesforceClient interface {
	GetCase(ctx context.Context, userID string) (salesforce.Case, error)
	CreateCase(ctx context.Context, params salesforce.CreateCaseParams) error
}

type Spade interface {
	QueueEvents(events ...spade.Event)
	Start() error
}

type UsersClient interface {
	GetUserByID(ctx context.Context, userID string, reqOpts *twitchclient.ReqOpts) (*users_models.Properties, error)
}

type HTTPConfig struct {
	service_common.BaseHTTPServerConfig
}

func (c *HTTPConfig) Load(d *distconf.Distconf) error {
	return c.BaseHTTPServerConfig.Verify(d, "martian")
}

func (s *HTTPServer) Setup() error {
	return s.BaseHTTPServer.Setup()
}

func (s *HTTPServer) Routes(mux *goji.Mux) {
	mux.Handle(pat.Get("/v1/users/:user_id/application"), s.CreateHandler("get_v1_application", s.getApplication))
	mux.Handle(pat.Post("/v1/users/:user_id/application"), s.CreateHandler("post_v1_application", s.postApplication))
}
