## Deploying Martian
Deployment is done using [clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/martian).

1. Create a new branch for a feature in [cb/martian](https://git.xarth.tv/cb/martian).
2. Ask CB in the slack channels #dashboard-feedback or #creator-business to create an AWS account for you.  Once you get your credentials, set up a twitch-cb-aws profile in your ~/.aws/credentials file
3. After writing your feature, you can test locally by running `AWS_PROFILE=twitch-cb-aws make precommit`. This will run formatting, linting, unit and integration tests.
4. Push up your branch and create a pull request.  This will run a build for your branch.  If the build fails, it will block the PR.
5. Ask in the slack channels #dashboard-feedback or #creator-business for a review.
6. After your PR is approved, merge your branch.  Your changes will automatically be deployed to staging.  Errors can be found logged to [Rollbar](https://rollbar.com/Twitch/CB_Martian/items/).
7. Deploy master to production using clean-deploy. Production errors are still logged in [Rollbar](https://rollbar.com/Twitch/CB_Martian/items/).
6. Verify that the [Elastic Beanstalk application](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-martian-production&environmentId=e-k6w62ukcnk) is healthy.  Also, check the [dashboard](https://grafana.internal.justin.tv/d/000001635/cb-martian?refresh=1m&orgId=1&var-env=production).

## Rollbacks
The fastest way to rollback a change is to use clean-deploy. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze Martian from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze martian` button in the top right corner.
