## Martian Runbook
This describes the different components of Martian and how to operate them.

[twitch-cb-aws account](https://twitch-cb-aws.signin.aws.amazon.com/console)
[Pagerduty](https://twitchoncall.pagerduty.com/services/PUFTDMR)
[Service Catalog](https://status.internal.justin.tv/services/374)
[Github](https://git.xarth.tv/cb/martian)
[clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/martian)

### Deploying and Rollbacks
See the deployment [docs](https://git.xarth.tv/cb/martian/tree/master/docs/deployment.md) for help with deploying and rolling back.

### Monitoring and Errors
Errors are logged to [rollbar](https://rollbar.com/Twitch/CB_Martian/items/).
There is a Grafana dashboard [here](https://grafana.internal.justin.tv/d/000001635/cb-martian).
Beanstalk apps can also be monitored from the AWS console
1. [API](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-martian-production&environmentId=e-k6w62ukcnk)

### Pagerduty
[Pagerduty](https://twitchoncall.pagerduty.com/services/PUFTDMR)
Pagerduty is integrated with Cloudwatch. Pages are sent based on application health.

### Terraform
Infrastructure configuration is done using terraform. All these files live in the [git repo](https://git.xarth.tv/cb/martian/tree/master/terraform). Changes should be applied to both staging and production, and committed to the repo using a pull request.

### Elastic Beanstalk
Martian exists as an elastic beanstalk application, for development, staging and production environments.
1. [production api](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-martian-production&environmentId=e-k6w62ukcnk)
2. [staging api](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-martian-staging&environmentId=e-dkgpgjqq4q)
3. [development api](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-martian-development&environmentId=e-t8hr99vypm)

### Storage
Martian is a simple pass-through to Salesforce, so it has no storage of it's own.  All state is stored in Salesforce.

### Cloudwatch
Application health and API latency is monitored through Cloudwatch.
1. [Application health alarm](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-martian-production-application-health)
2. [Service latency alarm](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-martian-production-latency)

### Past Alarms
None so far!
