package connections

import (
	"errors"

	"code.justin.tv/feeds/distconf"
)

// Config configures Client
type Config struct {
	Host *distconf.Str
}

// Load loads configuration values
func (c *Config) Load(dconf *distconf.Distconf) error {
	c.Host = dconf.Str("connections.host", "")
	if c.Host.Get() == "" {
		return errors.New("unable to find connections.host")
	}

	return nil
}
