package country

import "strings"

// ValidCode returns whether a given country code is valid.
func ValidCode(code string) bool {
	_, ok := validCodes[strings.ToUpper(code)]
	return ok
}

// Copied from https://git.xarth.tv/twilight/twilight/blob/224747bec33f47320945429d380bec64b0e0c2ea/src/common/utils/format-country.ts#L264-L522
var validCodes = map[string]struct{}{
	"US": {},
	"CA": {},
	"AF": {},
	"AX": {},
	"AL": {},
	"DZ": {},
	"AS": {},
	"AD": {},
	"AO": {},
	"AI": {},
	"A1": {},
	"AQ": {},
	"AG": {},
	"AR": {},
	"AM": {},
	"AW": {},
	"AP": {},
	"AU": {},
	"AT": {},
	"AZ": {},
	"BS": {},
	"BH": {},
	"BD": {},
	"BB": {},
	"BY": {},
	"BE": {},
	"BZ": {},
	"BJ": {},
	"BM": {},
	"BT": {},
	"BO": {},
	"BQ": {},
	"BA": {},
	"BW": {},
	"BV": {},
	"BR": {},
	"IO": {},
	"VG": {},
	"BN": {},
	"BG": {},
	"BF": {},
	"BI": {},
	"KH": {},
	"CM": {},
	"CV": {},
	"KY": {},
	"CF": {},
	"TD": {},
	"CL": {},
	"CN": {},
	"CX": {},
	"CC": {},
	"CO": {},
	"KM": {},
	"CG": {},
	"CD": {},
	"CK": {},
	"CR": {},
	"HR": {},
	"CU": {},
	"CW": {},
	"CY": {},
	"CZ": {},
	"DK": {},
	"DJ": {},
	"DM": {},
	"DO": {},
	"TL": {},
	"EC": {},
	"EG": {},
	"SV": {},
	"GQ": {},
	"ER": {},
	"EE": {},
	"ET": {},
	"EU": {},
	"FK": {},
	"FO": {},
	"FJ": {},
	"FI": {},
	"FR": {},
	"GF": {},
	"PF": {},
	"TF": {},
	"GA": {},
	"GM": {},
	"GE": {},
	"DE": {},
	"GH": {},
	"GI": {},
	"GR": {},
	"GL": {},
	"GD": {},
	"GP": {},
	"GU": {},
	"GT": {},
	"GG": {},
	"GN": {},
	"GW": {},
	"GY": {},
	"HT": {},
	"HM": {},
	"HN": {},
	"HK": {},
	"HU": {},
	"IS": {},
	"IN": {},
	"ID": {},
	"IR": {},
	"IQ": {},
	"IE": {},
	"IM": {},
	"IL": {},
	"IT": {},
	"CI": {},
	"JM": {},
	"JP": {},
	"JE": {},
	"JO": {},
	"KZ": {},
	"KE": {},
	"KI": {},
	"KW": {},
	"KG": {},
	"LA": {},
	"LV": {},
	"LB": {},
	"LS": {},
	"LR": {},
	"LY": {},
	"LI": {},
	"LT": {},
	"LU": {},
	"MO": {},
	"MK": {},
	"MG": {},
	"MW": {},
	"MY": {},
	"MV": {},
	"ML": {},
	"MT": {},
	"MH": {},
	"MQ": {},
	"MR": {},
	"MU": {},
	"YT": {},
	"MX": {},
	"FM": {},
	"MD": {},
	"MC": {},
	"MN": {},
	"ME": {},
	"MS": {},
	"MA": {},
	"MZ": {},
	"MM": {},
	"NA": {},
	"NR": {},
	"NP": {},
	"NL": {},
	"NC": {},
	"NZ": {},
	"NI": {},
	"NE": {},
	"NG": {},
	"NU": {},
	"NF": {},
	"KP": {},
	"MP": {},
	"NO": {},
	"OM": {},
	"O1": {},
	"PK": {},
	"PW": {},
	"PS": {},
	"PA": {},
	"PG": {},
	"PY": {},
	"PE": {},
	"PH": {},
	"PN": {},
	"PL": {},
	"PT": {},
	"PR": {},
	"QA": {},
	"RE": {},
	"RO": {},
	"RU": {},
	"RW": {},
	"BL": {},
	"SH": {},
	"KN": {},
	"LC": {},
	"MF": {},
	"PM": {},
	"VC": {},
	"WS": {},
	"SM": {},
	"ST": {},
	"A2": {},
	"SA": {},
	"SN": {},
	"RS": {},
	"SC": {},
	"SL": {},
	"SG": {},
	"SX": {},
	"SK": {},
	"SI": {},
	"SB": {},
	"SO": {},
	"ZA": {},
	"GS": {},
	"KR": {},
	"SS": {},
	"ES": {},
	"LK": {},
	"SD": {},
	"SR": {},
	"SJ": {},
	"SZ": {},
	"SE": {},
	"CH": {},
	"SY": {},
	"TW": {},
	"TJ": {},
	"TZ": {},
	"TH": {},
	"TG": {},
	"TK": {},
	"TO": {},
	"TT": {},
	"TN": {},
	"TR": {},
	"TM": {},
	"TC": {},
	"TV": {},
	"VI": {},
	"UG": {},
	"UA": {},
	"AE": {},
	"GB": {},
	"UM": {},
	"UY": {},
	"UZ": {},
	"VU": {},
	"VA": {},
	"VE": {},
	"VN": {},
	"WF": {},
	"EH": {},
	"YE": {},
	"ZM": {},
	"ZW": {},
}
