package jwt

import (
	"encoding/json"
	"strconv"
	"time"
)

// Expires marshals to unix.
type Expires time.Time

// MarshalJSON marshals to unix.
func (e Expires) MarshalJSON() ([]byte, error) {
	return json.Marshal(time.Time(e).Unix())
}

// UnmarshalJSON unmarshals from unix.
func (e *Expires) UnmarshalJSON(b []byte) error {
	var seconds int64

	if err := json.Unmarshal(b, &seconds); err != nil {
		return err
	}

	*e = Expires(time.Unix(seconds, 0))
	return nil
}

// String implements Stringer
func (e Expires) String() string {
	return strconv.FormatInt(time.Time(e).Unix(), 10)
}

// Claims is the JWT Claims Set.
type Claims struct {
	Audience string  `json:"aud"`
	Expires  Expires `json:"exp"`
	Issuer   string  `json:"iss"`
	Subject  string  `json:"sub"`
}
