package jwt

import (
	"io/ioutil"
	"testing"
	"time"
)

func Test_EncodeRS256_DecodeRS256(t *testing.T) {
	claims := Claims{
		Audience: "🐻",
		Expires:  Expires(time.Date(2000, 1, 2, 3, 4, 0, 0, time.UTC)),
		Issuer:   "✋",
		Subject:  "👽",
	}

	private, err := ioutil.ReadFile("./testdata/rsa256.pem")
	if err != nil {
		t.Error(err)
	}

	encoded, err := EncodeRS256(private, claims)
	if err != nil {
		t.Error(err)
	}

	public, err := ioutil.ReadFile("./testdata/rsa256.pub.pem")
	if err != nil {
		t.Error(err)
	}

	decodedClaims, err := DecodeRS256(public, encoded)
	if err != nil {
		t.Error(err)
	}

	if decodedClaims.Audience != claims.Audience {
		t.Errorf("expected %s, got %s", claims.Audience, decodedClaims.Audience)
	}
	if decodedClaims.Expires.String() != claims.Expires.String() {
		t.Errorf("expected %s, got %s", claims.Expires, decodedClaims.Expires)
	}
	if decodedClaims.Issuer != claims.Issuer {
		t.Errorf("expected %s, got %s", claims.Issuer, decodedClaims.Issuer)
	}
	if decodedClaims.Subject != claims.Subject {
		t.Errorf("expected %s, got %s", claims.Subject, decodedClaims.Subject)
	}
}
