package language

import "strings"

// ValidCode returns whether a given language code is valid.
func ValidCode(code string) bool {
	snakeCased := strings.Replace(code, "-", "_", -1)
	screamingSnakeCased := strings.ToUpper(snakeCased)
	_, valid := validCodes[screamingSnakeCased]

	return valid
}

// Copied from:
// - GQL: https://git.xarth.tv/edge/graphql/blob/acd95de82d7fb1a112a3f032057993f731a2727e/schema/types/language.graphql#L1-L107
// - Twilight: https://git.xarth.tv/twilight/twilight/blob/dc01505862036d894f79bf91f68621fcf24d440f/src/core/graphql/schema.ts#L184-L220
var validCodes = map[string]struct{}{
	"AR":    {},
	"ASL":   {},
	"BG":    {},
	"CA":    {},
	"CS":    {},
	"DA":    {},
	"DE":    {},
	"EL":    {},
	"EN":    {},
	"ES":    {},
	"FI":    {},
	"FR":    {},
	"HI":    {},
	"HU":    {},
	"ID":    {},
	"IT":    {},
	"JA":    {},
	"KO":    {},
	"MS":    {},
	"NL":    {},
	"NO":    {},
	"OTHER": {},
	"PL":    {},
	"PT":    {},
	"RU":    {},
	"RO":    {},
	"SK":    {},
	"SV":    {},
	"TH":    {},
	"TL":    {},
	"TR":    {},
	"UK":    {},
	"VI":    {},
	"ZH":    {},
	"ZH_HK": {},
}
