package language

import "testing"

func TestValidCode(t *testing.T) {
	tests := []struct {
		Code     string
		Expected bool
	}{
		{
			Code:     "",
			Expected: false,
		},
		{
			Code:     "en",
			Expected: true,
		},
		{
			Code:     "EN_GB",
			Expected: false,
		},
		{
			Code:     "zH-Hk",
			Expected: true,
		},
	}

	for _, test := range tests {
		if ValidCode(test.Code) != test.Expected {
			t.Errorf("validity of '%s' should be %t", test.Code, test.Expected)
		}
	}
}
