package salesforce

import (
	"encoding/json"
	"testing"
	"time"
)

func TestAPITimeMarshalJSON(t *testing.T) {
	someTime := apiTime(time.Date(2018, 7, 23, 21, 11, 11, 0, time.UTC))
	expected := `"2018-07-23T21:11:11+0000"`

	marshaled, err := json.Marshal(someTime)
	if err != nil {
		t.Error(err)
	}

	if string(marshaled) != expected {
		t.Errorf("expected %s, got %s", expected, string(marshaled))
	}
}

func TestAPITimeUnmarshalJSON(t *testing.T) {
	someTime := `"2018-07-23T21:11:11.000+0000"`
	expected := apiTime(time.Date(2018, 7, 23, 21, 11, 11, 0, time.UTC))

	var unmarshaled apiTime

	if err := json.Unmarshal([]byte(someTime), &unmarshaled); err != nil {
		t.Error(err)
	}

	if unmarshaled.Format() != expected.Format() {
		t.Errorf("expected %s, got %s", expected.Format(), unmarshaled.Format())
	}
}
