package oauth

import (
	"errors"

	"code.justin.tv/feeds/distconf"
)

// Config configures Client
type Config struct {
	ClientID         *distconf.Str
	Host             *distconf.Str
	RSA256PrivateKey *distconf.Str
	Username         *distconf.Str
}

// Load loads configuration values
func (c *Config) Load(dconf *distconf.Distconf) error {
	c.Host = dconf.Str("salesforce.oauth_host", "")
	if c.Host.Get() == "" {
		return errors.New("unable to find salesforce.oauth_host")
	}

	return nil
}

// LoadSecrets loads secret values
func (c *Config) LoadSecrets(dconf *distconf.Distconf) error {
	c.ClientID = dconf.Str("salesforce.client_id", "")
	if c.ClientID.Get() == "" {
		return errors.New("unable to find salesforce.client_id")
	}

	c.RSA256PrivateKey = dconf.Str("salesforce.rsa256_private_key", "")
	if c.RSA256PrivateKey.Get() == "" {
		return errors.New("unable to find salesforce.rsa256_private_key")
	}

	c.Username = dconf.Str("salesforce.username", "")
	if c.Username.Get() == "" {
		return errors.New("unable to find salesforce.username")
	}

	return nil
}
