package twitter

import (
	"code.justin.tv/feeds/log"
	"github.com/dghubble/go-twitter/twitter"
	"github.com/dghubble/oauth1"
	"github.com/pkg/errors"
	"golang.org/x/net/context"
)

// Client struct for Youtube.
type Client struct {
	Config Config
	Logger log.Logger
}

// OAuth is used to authorize requests to the Twitter API.
type OAuth struct {
	AccessToken  string
	AccessSecret string
}

// GetFollowerCount makes a GET request to Twitter apis' using their golang client
// https://dev.twitter.com/rest/public
func (c *Client) GetFollowerCount(ctx context.Context, id int64, oauth OAuth) (int64, error) {
	config := oauth1.NewConfig(c.Config.ConsumerKey.Get(), c.Config.ConsumerSecret.Get())
	token := oauth1.NewToken(oauth.AccessToken, oauth.AccessSecret)
	twitterClient := twitter.NewClient(config.Client(ctx, token))

	user, _, err := twitterClient.Users.Show(&twitter.UserShowParams{
		UserID: id,
	})
	if err != nil {
		return 0, errors.Wrapf(err, "twitter: failed to show user (id: %d)", id)
	}

	return int64(user.FollowersCount), nil
}
