package twitter

import (
	"context"
	"testing"

	"code.justin.tv/feeds/distconf"
)

func TestGetSubscriberCountFail(t *testing.T) {
	uff := distconf.Distconf{}
	client := &Client{
		Config: Config{
			ConsumerKey:    uff.Str("string", "string"),
			ConsumerSecret: uff.Str("string", "string"),
		},
	}

	result, err := client.GetFollowerCount(context.Background(), 123, OAuth{})

	if result != 0 {
		t.Error("Result should be 0 with no OAuth token")
	}
	if err == nil {
		t.Error("Error should not be nil with no OAuth token")
	}
}
