package twitter

import (
	"errors"

	"code.justin.tv/feeds/distconf"
)

// Config configures Client
type Config struct {
	ConsumerKey    *distconf.Str
	ConsumerSecret *distconf.Str
}

// LoadSecrets loads secret values
func (c *Config) LoadSecrets(dconf *distconf.Distconf) error {
	c.ConsumerKey = dconf.Str("twitter_consumer_key", "")
	if c.ConsumerKey.Get() == "" {
		return errors.New("unable to find twitter_consumer_key")
	}

	c.ConsumerSecret = dconf.Str("twitter_consumer_secret", "")
	if c.ConsumerSecret.Get() == "" {
		return errors.New("unable to find twitter_consumer_secret")
	}

	return nil
}
