#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

cp -R .ebextensions/ deploy/.ebextensions

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/cb/martian:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-martian-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

echo "$ENVIRONMENT-api-$GIT_COMMIT"

eb deploy cb-martian-$ENVIRONMENT-api \
  --label $ENVIRONMENT-api-$GIT_COMMIT \
  --message "$BRANCH" \
  --verbose

echo "cb.martian.api.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u graphite.internal.justin.tv 8125
