terraform {
  backend "s3" {
    bucket  = "cb-martian-terraform"
    key     = "development/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
  }
  required_version = ">= 0.12"
}

module "martian" {
  source                = "../modules/martian"
  environment           = "development"
  instance_type         = "t2.small"
  asg_max_size          = 1
  asg_min_size          = 1
  aws_key_name          = "cb-martian-development"
  sandstorm_role_arn    = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-martian-development"
  allow_assume_role_arn = "arn:aws:iam::989470033077:user/devtools-jenkins"
}

output "elb_dns_name" {
  value = module.martian.elb_dns_name
}

output "elb_zone_id" {
  value = module.martian.elb_zone_id
}
