resource "aws_cloudwatch_metric_alarm" "application_health" {
  alarm_name                = "${var.name}-${var.environment}-application-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS application"
  insufficient_data_actions = []

  dimensions = {
    EnvironmentName = var.ebs_name
  }

  alarm_actions = [aws_sns_topic.pagerduty_alarm.arn]
  ok_actions    = [aws_sns_topic.pagerduty_alarm.arn]
}

resource "aws_cloudwatch_metric_alarm" "elb_latency" {
  alarm_name          = "${var.name}-${var.environment}-latency"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "5"
  metric_name         = "Latency"
  namespace           = "AWS/ELB"
  period              = "60"
  statistic           = "Average"
  threshold           = "5"

  dimensions = {
    LoadBalancerName = var.elb_name
  }

  alarm_actions = [aws_sns_topic.pagerduty_alarm.arn]
  ok_actions    = [aws_sns_topic.pagerduty_alarm.arn]
}
