resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Principal": {
        ${var.allow_assume_role_arn != "" ? "\"AWS\": \"${var.allow_assume_role_arn}\"," : ""}
        "Service": "ec2.amazonaws.com"
      }
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  role = aws_iam_role.app.name
}

resource "aws_iam_role_policy" "policy" {
  name       = "${var.iam_role_name}_${var.environment}_policy"
  role       = aws_iam_role.app.id
  depends_on = [aws_iam_role.app]

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "sts:AssumeRole",
      "Resource": "${var.sandstorm_role_arn}"
    },
    {
      "Effect": "Allow",
      "Action": [
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Resource": [
        "arn:aws:logs:us-west-2:*:*",
        "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
      ]
    }
  ]
}
EOF
}
