variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_key_name" {
  type        = string
  description = "Key Pair for ElasticBeanstalk Application"
}

variable "name" {
  type        = string
  default     = "cb-martian"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "account" {
  type = map(string)

  default = {
    "production"  = "twitch-cb-aws"
    "staging"     = "twitch-cb-aws"
    "development" = "twitch-cb-aws"
  }

  description = "AWS account to use"
}

variable "instance_type" {
  type        = string
  description = "EC2 instance type"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "cb/martian"
  description = "GitHub repository name"
}

variable "sandstorm_role_arn" {
  type        = string
  description = "Sandstorm's AWS IAM Role ARN for assuming role"
}

variable "allow_assume_role_arn" {
  type        = string
  description = "AWS IAM Role ARN to allow to assume the application's role.  Used to allow jenkins to assume the development role so as to run integration tests"
  default     = ""
}

variable "team" {
  type        = string
  default     = "Creator Business"
  description = "Twitch team name"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  type    = string
  default = "cb-martian"
}
