terraform {
  backend "s3" {
    bucket  = "cb-martian-terraform"
    key     = "production/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
  }
  required_version = ">= 0.12"
}

module "martian" {
  source             = "../modules/martian"
  environment        = "production"
  instance_type      = "c4.large"
  asg_max_size       = 4
  asg_min_size       = 2
  aws_key_name       = "cb-martian-production"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-martian-production"
}

module "alarms" {
  name                      = "cb-martian"
  source                    = "../modules/alarms"
  environment               = "production"
  pagerduty_integration_url = "https://events.pagerduty.com/integration/c41bba6bc931404fa0ee94fca6e176c1/enqueue"
  ebs_name                  = module.martian.ebs_name
  elb_name                  = module.martian.elb_name
}

output "elb_dns_name" {
  value = module.martian.elb_dns_name
}

output "elb_zone_id" {
  value = module.martian.elb_zone_id
}
