terraform {
  backend "s3" {
    bucket  = "cb-martian-terraform"
    key     = "staging/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
  }
  required_version = ">= 0.12"
}

module "martian" {
  source             = "../modules/martian"
  environment        = "staging"
  instance_type      = "t2.small"
  asg_max_size       = 1
  asg_min_size       = 1
  aws_key_name       = "cb-martian-staging"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-martian-staging"
}
