package test

import (
	"context"
	"time"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

type AchievementsMock struct {
	PathToAffiliateCompletedAt *time.Time
	PathToPartnerCompletedAt   *time.Time
}

func (a *AchievementsMock) GetV1Quests(ctx context.Context, channelID string, reqOpts *twitchclient.ReqOpts) (*view.V1QuestsResponse, error) {
	return &view.V1QuestsResponse{
		Data: &view.V1QuestsData{
			Quests: []*view.V1Quest{
				{
					Key:         "path_to_affiliate",
					CompletedAt: a.PathToAffiliateCompletedAt,
				},
				{
					Key:         "path_to_partner",
					CompletedAt: a.PathToPartnerCompletedAt,
				},
			},
		},
	}, nil
}
