package test

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/web/users-service/client/channels"
	"code.justin.tv/web/users-service/models"
)

type ChannelsMock struct {
	GetError error
}

func (c *ChannelsMock) Get(ctx context.Context, id string, reqOpts *twitchclient.ReqOpts) (*channels.Channel, error) {
	return nil, c.GetError
}

func (c *ChannelsMock) GetByIDAndParams(ctx context.Context, id string, params *models.ChannelFilterParams, reqOpts *twitchclient.ReqOpts) (*channels.Channel, error) {
	return nil, nil
}

func (c *ChannelsMock) GetAll(ctx context.Context, ids []string, reqOpts *twitchclient.ReqOpts) (*channels.ChannelsResult, error) {
	return nil, nil
}

func (c *ChannelsMock) GetAllByParams(ctx context.Context, ids []string, params *models.ChannelFilterParams, reqOpts *twitchclient.ReqOpts) (*channels.ChannelsResult, error) {
	return nil, nil
}

func (c *ChannelsMock) GetByLogin(ctx context.Context, login string, reqOpts *twitchclient.ReqOpts) (*channels.Channel, error) {
	return nil, nil
}

func (c *ChannelsMock) GetByLoginAndParams(ctx context.Context, login string, params *models.ChannelFilterParams, reqOpts *twitchclient.ReqOpts) (*channels.Channel, error) {
	return nil, nil
}

func (c *ChannelsMock) GetAllByLogin(ctx context.Context, logins []string, reqOpts *twitchclient.ReqOpts) (*channels.ChannelsResult, error) {
	return nil, nil
}

func (c *ChannelsMock) GetAllByLoginAndParams(ctx context.Context, logins []string, params *models.ChannelFilterParams, reqOpts *twitchclient.ReqOpts) (*channels.ChannelsResult, error) {
	return nil, nil
}

func (c *ChannelsMock) Set(ctx context.Context, up models.UpdateChannelProperties, reqOpts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ChannelsMock) SetChannelWithAuth(ctx context.Context, up models.UpdateChannelProperties, editor string, reqOpts *twitchclient.ReqOpts) error {
	return nil
}
