package test

import (
	"net/url"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/identity/connections/client"
	"golang.org/x/net/context"
)

type ConnectionsMock struct {
	GetYoutubeUserError error
	GetTwitterUserError error
}

func (c *ConnectionsMock) AuthTwitter(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (string, error) {
	return "", nil
}

func (c *ConnectionsMock) GetTwitterUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (*connections.TwitterUser, error) {
	return nil, c.GetTwitterUserError
}

func (c *ConnectionsMock) CallbackTwitter(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) DeleteTwitterUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) AuthSteam(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) (string, error) {
	return "", nil
}

func (c *ConnectionsMock) CallbackSteam(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) GetSteamUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (*connections.SteamUser, error) {
	return nil, nil
}

func (c *ConnectionsMock) DeleteSteamUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) AuthYoutube(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (string, error) {
	return "", nil
}

func (c *ConnectionsMock) CallbackYoutube(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) GetYoutubeUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (*connections.YoutubeUser, error) {
	return nil, c.GetYoutubeUserError
}

func (c *ConnectionsMock) DeleteYoutubeUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) AuthBlizzard(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) (string, error) {
	return "", nil
}

func (c *ConnectionsMock) CallbackBlizzard(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) GetBlizzardUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (*connections.BlizzardUser, error) {
	return nil, nil
}

func (c *ConnectionsMock) DeleteBlizzardUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) GetBlizzardUserByBlizzardID(ctx context.Context, id string, opts *twitchclient.ReqOpts) (*connections.BlizzardUser, error) {
	return nil, nil
}

func (c *ConnectionsMock) AuthFacebook(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) (string, error) {
	return "", nil
}

func (c *ConnectionsMock) CallbackFacebook(ctx context.Context, uid string, values url.Values, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) GetFacebookUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) (*connections.FacebookUser, error) {
	return nil, nil
}

func (c *ConnectionsMock) DeleteFacebookUser(ctx context.Context, uid string, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) GetFacebookConnected(ctx context.Context, connectionID string, opts *twitchclient.ReqOpts) (*connections.FacebookUser, error) {
	return nil, nil
}

func (c *ConnectionsMock) AdminCreateFacebook(ctx context.Context, params connections.FacebookUser, opts *twitchclient.ReqOpts) error {
	return nil
}

func (c *ConnectionsMock) AdminDeleteFacebook(ctx context.Context, uid, connectionID string, opts *twitchclient.ReqOpts) error {
	return nil
}
