package twitch_client

import (
	"context"
	"io"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

type TwitchClientMock struct {
	NewRequestError error
}

func (t *TwitchClientMock) NewRequest(method string, path string, body io.Reader) (*http.Request, error) {
	return nil, t.NewRequestError
}

func (t *TwitchClientMock) Do(ctx context.Context, r *http.Request, opts twitchclient.ReqOpts) (*http.Response, error) {
	return nil, nil
}

func (t *TwitchClientMock) DoNoContent(ctx context.Context, r *http.Request, opts twitchclient.ReqOpts) (*http.Response, error) {
	return nil, nil
}

func (t *TwitchClientMock) DoJSON(ctx context.Context, o interface{}, r *http.Request, opts twitchclient.ReqOpts) (*http.Response, error) {
	return nil, nil
}
