package achievementsinternal

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1Quests makes a GET request to the Achievements Service for
// a given channel's quest progress and this endpoint doesn't require auth so it's for internal purposes only.
func (c *client) GetV1Quests(ctx context.Context, channelID string, reqOpts *twitchclient.ReqOpts) (*view.V1QuestsResponse, error) {
	path := fmt.Sprintf("/v1/internal/channels/%s/quests", channelID)

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-achievements.v1.get_quests",
		StatSampleRate: 0.1,
	})

	response := &view.V1QuestsResponse{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
