package xray

import "math/rand"

func (x *XRay) sample(seg *segment) bool {
	sampling := x.config().Sampling
	if sampling >= 1.0 {
		return true
	}
	if sampling <= 0.0 {
		return false
	}
	return x.float64() < sampling
}

func (x *XRay) float64() float64 {
	if x.RandSource != nil {
		return x.RandSource.Float64()
	}
	return rand.Float64()
}
