### ⚠️⚠️ As of 10-5-2017 Oracle is deprecated in favor of [GEA](https://git-aws.internal.justin.tv/twitch-events/gea) ⚠️⚠️

# Oracle

Oracle is a Golang web service for the Twitch Oracle project.

For more details, see the [CB/Oracle Wiki](https://wiki.twitch.com/display/CB/Oracle).

## Development

### Dependencies

All dependencies are version-controlled in the `vendor/` directory.

The `Makefile` `make update` command combines the installation of vendor packages as well as the stripping of unused vendor files.

#### Glide

[Glide](https://github.com/Masterminds/glide) is used for pinning package versions and for updating dependencies.

Glide is also used for [flattening](https://github.com/Masterminds/glide/blob/master/docs/getting-started.md#dependency-flattening) the `vendor/` directory, removing nested `vendor/` sub-directories.

To [install Masterminds/glide](https://github.com/Masterminds/glide#install) via [Homebrew](http://brew.sh/):

```sh
brew install glide
```

To use the Glide CLI tool:

```sh
glide update --strip-vendor
```

#### Glide Vendor Cleaner

[Glide Vendor Cleaner](https://github.com/sgotti/glide-vc) is used to remove vendor files not needed for the project.

To install `glide-vc`:

```sh
go get github.com/sgotti/glide-vc
```

To clean the `vendor/` directory:

```sh
glide-vc --only-code --no-tests --use-lock-file
```

## Testing

The `Makefile` `make test` command runs `go test` on the application packages, avoiding `vendor/`.

### Linting

The `Makefile` `make lint` command uses a series of linter tools for the project:

- [gofmt](https://golang.org/cmd/gofmt/)
- [go vet](https://golang.org/cmd/vet/)
- [errcheck](https://github.com/kisielk/errcheck)
- [aligncheck, structcheck, and varcheck](https://github.com/opennota/check)

Installing [Go Meta Linter](https://github.com/alecthomas/gometalinter) includes the above tools plus more.

It is _highly_ recommended that you install a Go linter plugin for your editor.

## Database Migrations

[mattes/migrate](https://github.com/mattes/migrate) is used for executing migrations for the Oracle service's own SQL data store.

### Setup

Install postgresql:

```sh
brew install postgresql
pg_ctl -D /usr/local/var/postgres -l /usr/local/var/postgres/server.log start
```

To utilize [`migrate` for PostgreSQL](https://github.com/mattes/migrate/tree/master/database/postgres), install the CLI tool:

```sh
go get -u -d github.com/mattes/migrate/cli github.com/lib/pq
go build -tags 'postgres' -o ~/go/bin/migrate github.com/mattes/migrate/cli
```

Create the database and run migrations:

```sh
createdb oracle
migrate -path=_db/migrations/ -database="postgres://localhost:5432/oracle?sslmode=disable" up
```

Start the server:

```sh
make dev
```

### Usage

Example command to create a migration file:

```sh
migrate -path=_db/migrations/ -database="postgres://localhost:5432/oracle?sslmode=disable" create add_some_table
```

Migration files are committed to the [`_db/migrations`](https://git-aws.internal.justin.tv/cb/oracle/tree/master/_db/migrations) directory.

Reverting all migrations:

```sh
migrate -path=_db/migrations/ -database="postgres://localhost:5432/oracle?sslmode=disable" down
```
