-- The `cover_images_status` type defines the `status` flavors:
--
-- * 'available': default cover image status
-- * 'admin_removed': cover image removed from the public by an admin user
-- * 'creator_removed': cover image removed from the public by the creator

CREATE TYPE cover_images_status AS ENUM ('available', 'admin_removed', 'creator_removed');


-- The `cover_images` table holds onto cover image records.

CREATE TABLE IF NOT EXISTS cover_images (
  id          bigserial             PRIMARY KEY,
  event_id    bigint                NOT NULL REFERENCES events (id),
  url         varchar               NOT NULL UNIQUE,
  status      cover_images_status   NOT NULL DEFAULT 'available'::cover_images_status,

  created_at  timestamp             NOT NULL DEFAULT current_timestamp,
  updated_at  timestamp
);

CREATE INDEX cover_images_event_id_idx ON cover_images (event_id);
CREATE UNIQUE INDEX cover_images_event_id_available_status_uniq_idx ON cover_images (event_id) WHERE status = 'available'::cover_images_status;

CREATE TRIGGER cover_images_before_update
BEFORE UPDATE ON cover_images
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_column();
