CREATE TABLE IF NOT EXISTS cover_images_history (
  operation       text        NOT NULL,
  effective_at    timestamp   DEFAULT current_timestamp NOT NULL,

  id              bigint      NOT NULL,
  event_id        bigint      NOT NULL,
  url             varchar     NOT NULL,
  status          text        NOT NULL,

  created_at      timestamp   NOT NULL,
  updated_at      timestamp

  CONSTRAINT cover_images_history_effective_at_after_now CHECK (effective_at >= current_timestamp)
);

CREATE INDEX cover_images_history_id_idx ON cover_images_history (id);


-- Protect the `cover_images_history` table from modification:

REVOKE ALL PRIVILEGES ON TABLE cover_images_history FROM PUBLIC;
GRANT SELECT ON TABLE cover_images_history TO PUBLIC;


-- Function and trigger to record the state of an event record (from the
-- `events` table) after inserting, deleting, or updating the record:

CREATE FUNCTION insert_cover_image_into_cover_images_history()
RETURNS TRIGGER AS $$
BEGIN
  IF (TG_OP = 'INSERT') THEN
    INSERT INTO cover_images_history VALUES(TG_OP, current_timestamp, NEW.*);
    RETURN NEW;
  ELSIF (TG_OP = 'DELETE') THEN
    INSERT INTO cover_images_history VALUES(TG_OP, current_timestamp, OLD.*);
    RETURN OLD;
  ELSIF (TG_OP = 'UPDATE') THEN
    INSERT INTO cover_images_history VALUES(TG_OP, current_timestamp, NEW.*);
    RETURN NEW;
  END IF;
  RETURN NULL;
END;
$$ LANGUAGE 'plpgsql';

CREATE TRIGGER cover_images_after_insert_delete_update
AFTER INSERT OR DELETE OR UPDATE ON cover_images
  FOR EACH ROW EXECUTE PROCEDURE insert_cover_image_into_cover_images_history();
