CREATE FUNCTION update_updated_at_column()
RETURNS trigger AS $$
BEGIN
  NEW.updated_at = current_timestamp;
  RETURN NEW;
END;
$$ LANGUAGE 'plpgsql';


DROP TRIGGER events_before_update ON events;

CREATE TRIGGER events_before_update
BEFORE UPDATE ON events
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_column();


DROP TRIGGER cover_images_before_update ON cover_images;


ALTER TABLE cover_images RENAME COLUMN created_at_utc TO created_at;
ALTER TABLE cover_images RENAME COLUMN updated_at_utc TO updated_at;

ALTER TABLE cover_images_history RENAME COLUMN created_at_utc TO created_at;
ALTER TABLE cover_images_history RENAME COLUMN updated_at_utc TO updated_at;


CREATE TRIGGER cover_images_before_update
BEFORE UPDATE ON cover_images
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_column();


DROP FUNCTION update_updated_at_utc_column();
