-- This migration effectively performs two things simultaneously:
--
-- 1. Rename the function update_updated_at_column() to update_updated_at_utc_column().
-- 2. Change the function to modify a newly named column `updated_at_utc`.
--
-- The columns that were still named without the `_utc` suffix are renamed.

CREATE FUNCTION update_updated_at_utc_column()
RETURNS trigger AS $$
BEGIN
  NEW.updated_at_utc = current_timestamp;
  RETURN NEW;
END;
$$ LANGUAGE 'plpgsql';


DROP TRIGGER cover_images_before_update ON cover_images;


ALTER TABLE cover_images RENAME COLUMN created_at TO created_at_utc;
ALTER TABLE cover_images RENAME COLUMN updated_at TO updated_at_utc;

ALTER TABLE cover_images_history RENAME COLUMN created_at TO created_at_utc;
ALTER TABLE cover_images_history RENAME COLUMN updated_at TO updated_at_utc;


CREATE TRIGGER cover_images_before_update
BEFORE UPDATE ON cover_images
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_utc_column();


DROP TRIGGER events_before_update ON events;

CREATE TRIGGER events_before_update
BEFORE UPDATE ON events
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_utc_column();


DROP FUNCTION update_updated_at_column();
